import heapq

import matplotlib.pyplot as plt
from scipy.spatial.distance import pdist
from scipy.spatial.distance import squareform

def distEclud(vecA,vecB):
    return sqrt(sum(power(vecA-vecB,2)))
def extract_cluster(densitySortArr,closestNodeIdArr, classNum,gamma):
    n=densitySortArr.shape[0]
    # Initializes the class of each point
    labels=np.full((n,),-1)
    corePoints =  np.argsort(-gamma)[: classNum]
    # Assign a category to the selected cluster center
    labels[corePoints]=range(len(corePoints))
    # Converts the ndarrar array to a list collection
    densitySortList=densitySortArr.tolist()
    # Inverts the set elements, that is, the order index from highest density to lowest density
    densitySortList.reverse()
    # Iterate to assign a label to each element
    for nodeId in densitySortList:
        if(labels[nodeId]==-1):
            # If the nodeId node has no category
            # Firstly, obtain the index of closestNodeIdArr[nodeId], which represents the nearest point with a higher density than the current point.
            # Assign the class of the nearest point that has a higher density than itself to the nodeId.
            labels[nodeId]=labels[closestNodeIdArr[nodeId]]
    return corePoints,labels

def CFSFDP(data,dc):
    n,m=data.shape
    # Create a distance matrix for any two points.
    disMat = squareform(pdist(data,metric='euclidean'))

    # Calculate the density of each point (i.e., how many points are within a circle of radius dc centered at that point).
    densityArr = np.where(disMat < dc, 1, 0).sum(axis=1)

    # Sort the data points based on their density in ascending order (from smallest to largest).
    densitySortArr=np.argsort(densityArr)
    # Initialize: the nearest distance to a point with a higher density than oneself.
    closestDisOverSelfDensity = np.zeros((n,))
    # Initialize: the node ID corresponding to the nearest distance to a point with a higher density than oneself.
    closestNodeIdArr = np.zeros((n,), dtype=np.int32)
    # Iterate starting from the point with the smallest density.
    for index,nodeId in enumerate(densitySortArr):
        # Set of points with density greater than the current point.
        nodeIdArr = densitySortArr[index+1:]
        # If it is not the point with the maximum density.
        if nodeIdArr.size != 0:
            # Calculate the set of distances from nodeId to points with higher density than itself.
            largerDistArr = disMat[nodeId][nodeIdArr]
            # Find the node with the smallest distance that has a higher density than oneself.
            closestDisOverSelfDensity[nodeId] = np.min(largerDistArr)
            # Find the index of the minimum value, where the index corresponds to the one in largerdist (ensuring it is for a node with a higher density than nodeId).
            # If there are multiple nearest nodes, take the first one.
            # Note that the index here refers to the one within largerDistArr.
            min_distance_index = np.argwhere(largerDistArr == closestDisOverSelfDensity[nodeId])[0][0]
            # Obtain the index value within the entire dataset.
            closestNodeIdArr[nodeId] = nodeIdArr[min_distance_index]
        else:
            # If it is the point with the maximum density, set its distance to the maximum value and its corresponding ID to itself.
            closestDisOverSelfDensity[nodeId] = np.max(closestDisOverSelfDensity)
            closestNodeIdArr[nodeId] = nodeId
    #  Due to the potential difference in magnitude between the density and the shortest distance attributes, normalize both of them separately to make the results smoother.
    epsilon = 1e-9  # A small quantity used to avoid division by zero.
    normal_den = (densityArr - np.min(densityArr)) / (np.max(densityArr) - np.min(densityArr) + epsilon)
    normal_dis = (closestDisOverSelfDensity - np.min(closestDisOverSelfDensity)) / (
                np.max(closestDisOverSelfDensity) - np.min(closestDisOverSelfDensity))
    aver = np.sum(normal_den) / m
    gamma = normal_den * normal_dis
    return densityArr,densitySortArr,closestDisOverSelfDensity,closestNodeIdArr,gamma

import numpy as np
from scipy.spatial.distance import cdist

def MPV(data,labels,pairwise_distances,center_distances):
    center_dists=center_distances[center_distances>0].min()
    inter_center_dists = +np.inf
    for iter1 in range(len(np.unique(labels))):
        #if(pairwise_distances[labels==iter1,:][:,labels!=iter1].shape[0]!=0):
        inter_center_dists = min(
            inter_center_dists,
            pairwise_distances[labels==iter1,:][:,labels!=iter1].min()
        )
    mini=100000000
    #if(center_dists>inter_center_dists):
    center_dists = math.sqrt(inter_center_dists*center_dists)

    del center_distances
    del pairwise_distances
    max=0
    for interl in range(len(np.unique(labels))):
        data1=data[labels==interl]
        n=data1.shape[0]
        sum=0
        pairwise_distances = cdist(data1,data1,metric='euclidean')
        for i in range(0,n-1):
            sum = sum + pairwise_distances[i][i+1:].min()
        sum = sum / n
        if(max<sum):
            max=sum
        del pairwise_distances

    if(max>center_dists):
        max=center_dists

    return center_dists/max
def show(dataSet, k, centroids, clusterAssment):
    from matplotlib import pyplot as plt
    numSamples, dim = dataSet.shape
    mark = ['b*', 'g.', 'y*', 'r.', 'b*', 'g.', 'r*', 'y.', '<r', 'pr']
    for i in range(numSamples):
        markIndex = int(clusterAssment[i])
        plt.plot(dataSet[i, 0], dataSet[i, 1], mark[markIndex])

    plt.show()
import xlwt
def main13(data,dc):
    minK = 2
    book = xlwt.Workbook()
    # Create a sheet
    sheet1 = book.add_sheet(u'sheet1', cell_overwrite_ok=True)
    n = data.shape[0]
    maxK = int(math.sqrt(n))
    index = np.zeros((maxK - minK))
    index1 = np.zeros((maxK - minK))
    densityArr, densitySortArr, closestDisOverSelfDensity, closestNodeIdArr, gamma,pairwise_distances  = CFSFDP(data,dc)

    gam = sorted(gamma, reverse=True)
    y = np.zeros(shape=(maxK), dtype="float64")
    for k in range(minK, maxK):
        corePoints, labels = extract_cluster(densitySortArr, closestNodeIdArr, k, gamma)
        myCentroids =data[corePoints]
        center_distances = cdist(myCentroids, myCentroids)
        value=MPV(data,labels,pairwise_distances,center_distances)
        y[k]=value
        index[k - minK] =value
        sheet1.write(k-1, 2, value)
    x = np.zeros(shape=(k), dtype="int32")
    x = range(k)
    plt.scatter(x[2:k - 1], y[2:k - 1], color='r')
    plt.xticks(range(1, 15, 2))
    plt.show()
    a=0
    for k in range(minK, maxK-1):
        index1[k - minK] = y[k]-y[k+1]
        if (index1[k-minK] == 0):
            a=a+1
    if(a==maxK-2):
        est_k=2
    else:
        est_k = index1.argmax() + minK
    print('Selected k =', est_k)
    corePoints, labels = extract_cluster(densitySortArr, closestNodeIdArr, est_k, gamma)
    myCentroids = data[corePoints]
    labal_pre = labels
    show(data, est_k, myCentroids, labal_pre)
def MaxMinNormalization(data):
    Min=np.min(data)
    Max=np.max(data)
    data = (data - Min) / (Max - Min);
    return data
import struct
import time
from numpy import *
